{if $input.mapId}
	<form id="edit-share-code" method="post" action="{service controller=tracker action=update_item itemId=$input.mapId trackerId=$input.trackerId}">
		<label>
			{tr}Share Code{/tr}
			<input type="text" name="fields~shareCode" value="{$input.shareCode|escape}" id="sharecode" style="width:120px" />
			<img src="img/icons/error.png" style="display:none" width="16" height="16" title="{tr}Share{/tr}|{tr}Share codes can contain only letters and numbers{/tr} {if $prefs.unified_engine eq 'mysql'}and a minimum length of five characters{/if}" class="tips" />
		</label>
		<input type="submit" value="{tr}Modify{/tr}"/>
		<label>
			<input type="checkbox" id="nojoin" onchange="$('#appframe .map-container').trigger('initialized');">
			{tr}Duplicate{/tr}
		</label>
	</form>
{/if}
{if $input.shareCode or ! $input.mapId}
<form class="simple" method="POST" action="{$page|escape}">
	<label>
		{tr}Public Permalink{/tr}
		<input id="permalink" type="url" value=""/>
	</label>
	<label>
		{tr}Embed Code{/tr}
		<textarea id="embed-map"></textarea>
	</label>
</form>
{/if}
{jq}
	var input = {{$input|json_encode}}
		, baseUrl = {{$base_url|json_encode}}
		, page = {{$page|json_encode}}
		;
	$('#edit-share-code').submit(function () {
		if ($("#sharecode").val().match(/\W/)) {
			alert("{tr}Share codes can contain only letters and numbers{/tr}");
			$("#sharecode").focus().keyup();
			return false;
		}
{{if $prefs.unified_engine eq 'mysql'}
		if ($("#sharecode").val().length < 5) {
			alert("{tr}Share codes must be at least five characters long{/tr}");
			$("#sharecode").focus().keyup();
			return false;
		}
{/if}}
		var form = this;

		$.post($(this).attr('action'), $(this).serialize(), function () {
			document.location.href = 
				page + '?coordinates=' + encodeURIComponent(input.coordinates)
				+ '&mapId=' + encodeURIComponent(input.mapId)
				+ '&mapName=' + encodeURIComponent(input.mapName)
				+ '&shareCode=' + encodeURIComponent($(':text', form).val())
				+ '#Share'
				;
		}, 'json');
		return false;
	});
	$("#sharecode").keyup(function(){
		if ($(this).val().match(/\W/)) {
			$(this).next("img").show();
		} else {
			$(this).next("img").hide();
		}
	});
	$('#appframe .map-container').bind('initialized', function () {
		var container = this, updatePermalink;
		updatePermalink = function () {
			var url = baseUrl + page + '?coordinates=' + encodeURIComponent($(container).getMapCenter());

			if (input.shareCode) {
				url = url
					+ '&shareCode=' + encodeURIComponent(input.shareCode)
					+ '&mapName=' + encodeURIComponent(input.mapName)
					+ '&sourceId=' + encodeURIComponent(input.mapId ? input.mapId : input.originalId)
					+ ($("#nojoin:checked").length ? '&nojoin=y' : '')
					+ '#' + tr('Map')
					;
			}

			$('#permalink')
				.val(url)
				.closest('form').attr('action', url);
			$('#embed-map')
				.val($('<iframe/>').attr('src', url).attr('height', 400).attr('width', 600).wrap('<div/>').parent().html());
		};

		this.map.events.on({
			move: updatePermalink
		});

		updatePermalink();
	});
	$('#permalink, #embed-map').click(function () {
		$(this).select();
		return false;
	});
	// fix for removing scrollbars on maps only
	$("body").css("overflow", "hidden");
{/jq}
