<a class="map-custom-print" href="">{tr}Print{/tr}</a>
{jq}
$('.map-custom-print').click(function (e) {
	e.preventDefault();
	var container = $('#appframe .map-container')[0], allDone = false;

	while (container.map.controls.length) {
		container.map.controls[0].deactivate();
		container.map.removeControl(container.map.controls[0]);
	}
	
	var elements = [];
	$(container).finalMapRefresh(function (result, feature) {
		elements.push({
			data: result,
			feature: feature
		});
	});

	var dialog = $('<div/>').dialog({
		modal: true,
		title: 'Loading...',
	});

	setTimeout(function () {
		var $legend = $('#map-legend');
		$title = $("<h1/>").text($(".map-info h3").text());
		$finder = $("<p/>").text(tr("By") + " " + $("#map-legend-add input[name='forced~finder']").val());

		$('#main')
			.empty()
			.append($title)
			.append($finder)
			.append(container)
			.append($legend.css('page-break-before', 'always'));
		// TODO add description here somehow one day

		var mapCount = elements.length + 1;

		$.each(elements, function (k, data) {
			var div = $('<div/>');

			div.css({'clear':'both','height': '215px'});

			$('<div>').width(200).height(200)
				.css('float', 'left')
				.appendTo(div)
				.data('map-controls', '')
				.createMap()
				.bind('initialized', function () {
					this.vectors.addFeatures([data.feature]);
					this.map.zoomToExtent(data.feature.geometry.getBounds());

					if (container.map.getZoom() < this.map.getZoom()) {
						this.map.zoomTo(container.map.getZoom());
					}

					if (--mapCount === 0) {
						dialog.dialog('destroy');

						setTimeout(function () {
							window.print();
							setTimeout(function () {
								alert(tr("Click ok to continue"));
								if (window.location.hash) {
									window.location.replace(window.location.href.replace(window.location.hash, "#" + tr("Share")));
								} else {
									window.location.replace(window.location.href + "#" + tr("Share"));
								}
								window.location.reload(true);
							}, 500);
						}, 500);
					}
				});

			$('<h2>')
				.append($(data.data.link).text())
				.appendTo(div);

			$('<div/>')
				.append(data.data.tracker_field_finder)
				.appendTo(div);

			var d = new Date(1000 * data.data.modification_date);
			$('<div/>')
				.append($.datepicker.formatDate('yy-mm-dd', d))
				.appendTo(div);

			$('<div/>')
				.append(data.data.tracker_field_zoneDescription)
				.append(data.data.tracker_field_poiDescription)
				.appendTo(div);

			$('#main').append(div);
		});

		if (--mapCount === 0) {
			dialog.dialog('destroy');

			setTimeout(function () {
				window.print();
				setTimeout(function () {
					if (window.location.hash) {
						window.location.replace(window.location.href.replace(window.location.hash, "#" + tr("Share")));
					} else {
						window.location.replace(window.location.href + "#" + tr("Share"));
					}
					window.location.reload(true);
				}, 500);
			}, 500);
		}

	}, 2000);
	return false;
});
{/jq}
