/**
 * Cartograf custom js
 */

if (!!!document.createElementNS || !!!document.createElementNS('http://www.w3.org/2000/svg', 'svg').createSVGRect) {
  $("<div />")
		  .text(tr("Your browser does not support SVG (required for drawing), please upgrade."))
		  .addClass("browser-error")
		  .prependTo("#main")
		  .slideDown();
}

$(document).bind("initialized", function() {	// map initialized event
	$('.olControlZoomBoxItemActive, .olControlZoomBoxItemInactive').attr("title", tr("Select Area to Zoom"));
	$(".overlay.top_icons a").each( function() {
		$(this).show();
	});
	var cookie = getCookie("hash", "maps");
	if (!location.hash && cookie) {
		cookie = cookie.replace(/^#/, "");
		location.hash = cookie;
		setTimeout( function () { $("img[alt=" + cookie + "]").parents(".anchor-toggle").click(); }, 2000);
		deleteCookie("hash", "maps");
	}
	return true;	// pass it on
});

$(document).on("iconsloaded", function( event ) {
	var $contentsDiv = $(".ui-dialog:last .contents");
	// get the first icon in the contents div, needed to be able to clone the click event
	var $exampleImg =  $("img:first", $contentsDiv).parent().clone(true);

	$("li > img", "#map-legend").each(function () {
		var $toAppend = $exampleImg.clone(true);
		var src = $(this).attr("src");
		var fileId = src.match(/\d*$/);	// ends in a number?
		if (fileId && fileId.length && fileId[0] && !isNaN(fileId[0])) {
			fileId = fileId[0];
			$("img", $toAppend).replaceWith($(this).clone());
			$toAppend.
				data("object", fileId).
				attr("href", src).
				attr("title", $(this).parent().text().replace($(this).parent().find("a").text(), ""));

			if ($("a[href='" + src + "']", $contentsDiv).length === 0) {
				$contentsDiv.append($toAppend);
			}
		}
	});
	$("image", ".map-container").each(function () {
		var $toAppend = $exampleImg.clone(true);
		//$("img", $toAppend).replaceWith($(this).clone());
		var src = $(this).attr("href");
		var fileId = src.match(/\d*$/);	// ends in a number?
		if (fileId && fileId.length && fileId[0] && !isNaN(fileId[0])) {
			$("img", $toAppend).attr("src", src);
			fileId = fileId[0];
			$toAppend.
				data("object", fileId).
				attr("href", src).
				attr("title", $(this).parent().text().replace($(this).parent().find("a").text(), ""));

			if ($("a[href='" + src + "']", $contentsDiv).length === 0) {
				$contentsDiv.append($toAppend);
			}
		}

	});
} );