/**
 * Cartograf custom js
 */

$(document).ready(function () {
	if (! document.createElementNS || ! document.createElementNS("http://www.w3.org/2000/svg", "svg").createSVGRect) {
	  $("<div />")
			  .text(tr("Your browser does not support SVG (required for drawing), please upgrade."))
			  .addClass("browser-error")
			  .prependTo("#main")
			  .slideDown();
	}

	$(document).bind("initialized", function() {	// map initialized event
		$(".olControlZoomBoxItemActive, .olControlZoomBoxItemInactive").attr("title", tr("Select Area to Zoom"));
		$(".overlay.top_icons a").each( function() {
			$(this).show();
		});
		var cookie = getCookie("hash", "maps");
		if (!location.hash && cookie) {
			cookie = cookie.replace(/^#/, "");
			location.hash = cookie;
			setTimeout( function () { $("img[alt=" + cookie + "]").parents(".anchor-toggle").click(); }, 2000);
			deleteCookie("hash", "maps");
		}
		return true;	// pass it on
	});

	$(document).on("iconsloaded", function( event ) {
		var $contentsDiv = $(".ui-dialog:last .contents");
		// get the first icon in the contents div, needed to be able to clone the click event
		var $exampleImg =  $("img:first", $contentsDiv).parent().clone(true);

		$("li > img", "#map-legend").each(function () {
			var $toAppend = $exampleImg.clone(true);
			var src = $(this).attr("src");
			var fileId = src.match(/\d*$/);	// ends in a number?
			if (fileId && fileId.length && fileId[0] && !isNaN(fileId[0])) {
				fileId = fileId[0];
				$("img", $toAppend).replaceWith($(this).clone());
				$toAppend.
					data("object", fileId).
					attr("href", src).
					attr("title", $(this).parent().text().replace($(this).parent().find("a").text(), ""));

				if ($("a[href='" + src + "']", $contentsDiv).length === 0) {
					$contentsDiv.append($toAppend);
				}
			}
		});
		$("image", ".map-container").each(function () {
			var $toAppend = $exampleImg.clone(true);
			//$("img", $toAppend).replaceWith($(this).clone());
			var src = $(this).attr("href");
			var fileId = src.match(/\d*$/);	// ends in a number?
			if (fileId && fileId.length && fileId[0] && !isNaN(fileId[0])) {
				$("img", $toAppend).attr("src", src);
				fileId = fileId[0];
				$toAppend.
					data("object", fileId).
					attr("href", src).
					attr("title", $(this).parent().text().replace($(this).parent().find("a").text(), ""));

				if ($("a[href='" + src + "']", $contentsDiv).length === 0) {
					$contentsDiv.append($toAppend);
				}
			}

		});
	});


	/// example code to allow line width to be modifiedExample
	$(".map-container").on("initialized", function () {
		$(".map-container")[0].defaultStyleMap.styles.default.context.getStrokeWidth = function () { return 4; };
	});


	/* override this functioon from lib/jquery_tiki/tiki-ajax_services.js
	 * to close the ui-dialog after the annoying 15.x redirecting in xx seconds thing
	 */

	var oldConfirmAction = window.confirmAction;

	window.confirmAction = function(form) {
		//this is the ajax action once the confirm submit button is clicked
		$.ajax({
			dataType: 'json',
			url: $(form).attr('action'),
			type: 'POST',
			data: $(form).serialize(),
			success: function (data) {
				var extra = data.extra || false, forward = data.FORWARD || false, dataurl = data.url || false,
					feedback = data.feedback || false, modal = data.modal || false;
				/* if extra is set to post and forward and modal are not set
				feedback is put in a predefined feedback box on the page itself
				after the page is refreshed
				 */
				if (extra && !forward && !modal) {
					//page is refreshed and feedback information is posted back to url
					//requires php and smarty tpl logic to receive and display
					if (extra === 'post') {
						var newform = $('<form/>', {id: 'ajaxfeedback', action : location.href, method : 'POST'})
							.append($('<input />', {type: 'submit'}));
						if (feedback) {
							$.each(feedback, function (key, value) {
								if ($.isArray(value) || $.isPlainObject(value)) {
									$.each(value, function (key2, value2) {
										newform.append($('<input />',
											{type: 'hidden', name: key + '[' + key2 + ']', value: value2}));
									});
								} else {
									newform.append($('<input />', {type: 'hidden', name: key, value: value}));
								}
							});
						}
						newform.appendTo(document.body).submit();
						return false;
					}
				}
				/*
				If forward and modal are set, the FORWARD service is passed to the modal and
				replaces the contents. Redirect and timer functionality are incorporated as well
				 */
				if (forward && modal && 0) {// *** cartograf fix for jquery-ui dialog ***
					//clear modal content
					$(form).children().remove();
					//load service in forward
					$(form).loadService(forward, {origin: form});
					//clear all buttons except for the close (modal dismiss) button
					$(form).closest('.modal').find('.modal-footer .btn').not('.btn-dismiss').remove();
					//put an event listener for the modal closing
					$(form).closest('.modal').on('hidden.bs.modal', function () {
						if (dataurl) {
							//redirect to specified url in data.url
							document.location.href = dataurl;
						} else{
							//otherwise, refresh page
							document.location.href = document.location.href.replace(/#.*$/, "");
						}
					});
					//set timer and close modal once expired (triggering redirect/refresh)
					counter = forward.ajaxtimer;
					timer = setInterval(function() {
						$('span#timer-seconds').html(--counter);
						if (counter == 0 || counter < 0) {
							clearTimeout(timer);
							$.closeModal();
						}
					}, 1000);
					return false;
				} else {
					$.closeModal();
				}
				//if there's a data.FORWARD after ajax success, then this function assumes it needs to inject an alert
				//into the current page and then redirect to a second page. Used in user controller for banning
				if (forward){
					var alerthref, parsedhtml, alert, msgdiv, timer, counter;
					alerthref = $.service(forward.controller, forward.action, forward);
					$.ajax({
						dataType: 'html',
						url: alerthref,
						type: 'POST',
						success: function (data2) {
							$('div#posted-ajax-feedback').fadeOut(1000);
							//insert the success alert onto the page
							parsedhtml = $.parseHTML(data2);
							//extracts content from templates/utilities/alert.tpl
							alert = $(parsedhtml).find('div#alert-wrapper');
							//receiving page needs to have a div with id ajax-feedback
							msgdiv = $('div#ajax-feedback');
							if (msgdiv.length === 0){
								return false;
							}
							msgdiv.html(alert.html())
								.fadeIn(1000);
							//scroll up to feedback alert if not visible
							if ($(document).scrollTop() > msgdiv.offset().top) {
								$('html, body').animate({
									scrollTop: msgdiv.offset().top
								}, 1000);
							}
							counter = forward.ajaxtimer;
							timer = setInterval(function() {
								$('span#timer-seconds').html(--counter);
								if (counter == 0 || counter < 0) { clearInterval(timer)}
							}, 1000);
						}
					});
					if (dataurl) {
						setTimeout(function () {
							window.location.href = dataurl;
							return false;
						}, (data.FORWARD.ajaxtimer + 1) * 1000);
					}
				} else {
					return false;
				}
				return false;
			},
			error: function (jqxhr, status, errorObj) {
				var msgdiv = $('div#error_report');
				$.closeModal();
				if ($(document).scrollTop() > msgdiv.offset().top) {
					$('html, body').animate({
						scrollTop: msgdiv.offset().top
					}, 1000);
				}
			},
			// *** cartograf fix part 2 for jquery-ui dialog ***
			complete: function () {
				$(form).parents(".ui-dialog-content").dialog("close");
			}
		});
	};


});



/***
 * Print out the current map and it's features
 */
function printMap(photos) {

	var printFeatureAttachments = photos ? true : false;

	var container = $(".map-container", "#appframe")[0],
		$container = $(container),
		allDone = false,
		elements = [],
		mapId = $("input[name=itemId]").val() || $("input[name='forced~map']").val();

	while (container.map.controls.length) {
		container.map.controls[0].deactivate();
		container.map.removeControl(container.map.controls[0]);
	}

	$container.finalMapRefresh(function (result, feature) {
		if (feature.getVisibility()) {
			elements.push({
				data: result,
				feature: feature
			});
		}
	});


	var dialog = $("<div>" + tr("Make sure your page setup is set to landscape") + "</div>").dialog({
		modal: true,
		title: "Loading..."
	});

	setTimeout(function () {

		var item = [];

		$.ajax($.service("tracker", "view"), {	// get the full map item
			data: {
				id: mapId
			},
			async: false,
			type: "POST",
			dataType: "JSON"
		})
			.done(function (data) {
				item = data;
				var fields = item["fields"];
				for (var i = 0; i < fields.length; i++) {
					item[fields[i]["permName"]] = fields[i];
				}
			})
			.fail(function (data) {
				item = data;
			});

		var $legend = $("#map-legend"),
			$title = $("<h1/>").text($(".map-info h3").text()),
			$finder = $("<p/>").text(tr("By") + " " + $("input[name='forced~finder']", "#map-legend-add").val());
			//$date = $("<div/>").addClass("date").text(item.modification_date.substr(0,10));

		var $main = $("#main");
		$main
			.empty()
			.empty()
			.append($title)
			.append($finder)
			//.append($date)	// date not available in trascker view yet
			.append(container)
			.addClass("printing");

		// try and work out the max height for the main map
		var offset = $title.outerHeight() + $finder.outerHeight(); // + $date.outerHeight(),
			height = $container.height(),
			max = 600;	// seems somewhat arbitrary nothing else seems to do it

		if (height > max) {
			$container.height(max - offset);
		}
		container.map.updateSize();

		// add description here
		$("<div />")
			.addClass("map-description")
//			.height($container.height())
			.append($title.clone())
			.append($finder.clone())
			.append($("<div />").html(item["mapDescription"]["pvalue"]))
			.appendTo($main);

		$legend.appendTo($main);

		var mapCount = elements.length + 1;

		var finishPrinting = function () {	// called after the print dialog clears
			setTimeout(function () {
				alert(tr("Click ok to continue"));
				if (window.location.hash) {
					window.location.replace(window.location.href.replace(window.location.hash, "#" + tr("Share")));
				} else {
					window.location.replace(window.location.href + "#" + tr("Share"));
				}
				window.location.reload(true);
			}, 1000);
		};

		$.each(elements, function (k, data) {

			var div = $("<div/>").addClass("map-feature");

			var div2 = 	$("<div />").addClass("map-description").css("page-break-before", "avoid");

			var $fTitle = $("<h2>")
				.append($("<img>").attr("src", data.data.tracker_field_poiIcon))
				.append($(data.data.link).text())
				.appendTo(div2);

			var $fFinder = $("<div/>")
				.addClass("finder")
				.append(tr("By") + " " + data.data.tracker_field_finder)
				.appendTo(div2);

			var $fDate = $("<div/>")
				.addClass("date")
				.text(data.data.modification_date.substr(0,10))
				.appendTo(div2);

			$("<div/>")
				.addClass("description")
				.addClass("clearfix")
				.append(data.data.tracker_field_zoneDescription)
				.append(data.data.tracker_field_poiDescription)
				.appendTo(div2);


			var image = data.data.tracker_field_poiImage || data.data.tracker_field_zoneImage,
				i = 0, images = [],  $img;

			if (image) {
				images = image.split(",");

				$.ajax('tiki-searchindex.php', {
					data: {
						filter: {
							object_type: "file",
							object_id: images.join(" OR ")
						}
					},
					async: false,
					type: "POST",
					dataType: "JSON"
				})
					.done(function (data) {
						images = data;
					})
					.fail(function (data) {
						images = data;
					});

				for (i in images) {
					if (images[i].filetype === "image/svg") {
						$img = $("<object type=\"image/svg+xml\" data=\"display" + images[i].object_id + "?y=120\" height=\"120\">");
					} else {
						$img = $("<img src=\"display" + images[i].object_id + "?y=120\" height=\"120\">");
					}
					$("<div/>")
						.addClass("poiImage")
						.append($img)
						.appendTo(div2);
				}
			}

			div2.appendTo(div);

			$("<div>").width(200).height(200)
				.appendTo(div)
				.data("map-controls", "")
				.createMap()
				.bind("initialized", function () {
					this.vectors.addFeatures([data.feature.clone()]);
					this.map.zoomToExtent(data.feature.geometry.getBounds());

					if (container.map.getZoom() < this.map.getZoom()) {
						this.map.zoomTo(container.map.getZoom());
					}

					if (--mapCount === 0) {

						setTimeout(function () {
							dialog.dialog("destroy");
							window.print();
							finishPrinting();
						}, printFeatureAttachments ? 4000 : 500);
					}
				});


			if (images && printFeatureAttachments) {
				for (i in images) {

					if (images[i].filetype === "image/svg") {
						$img = $("<object type=\"image/svg+xml\" data=\"display" + images[i].object_id + "?y=400\" height=\"400\">");
					} else {
						$img = $("<img src=\"display" + images[i].object_id + "?y=400\" height=\"400\">");
					}
					$("<div/>")
						.addClass("map-description")
						.append($fTitle.clone())
						.append($("<h3>").text(images[i].title))
						.append($fFinder.clone())
						.append($fDate.clone())
						.append($img)
						.append($("<div>").addClass("description").html(images[i].description))
						.appendTo(div);

					$("<div>").width(200).height(200)
						.appendTo(div)
						.data("map-controls", "")
						.createMap()
						.bind("initialized", function () {
							this.vectors.addFeatures([data.feature.clone()]);
							this.map.zoomToExtent(data.feature.geometry.getBounds());

							if (container.map.getZoom() < this.map.getZoom()) {
								this.map.zoomTo(container.map.getZoom());
							}
						});
				}
			}

			$("#main").append(div);
		});

		if (--mapCount === 0) {
			dialog.dialog("destroy");
			window.print();
			finishPrinting();
		}

	}, 2000);

}


