<div class="map-info">
	<h3>{$input.title|escape}</h3>
	<p class="clearfix">
		{if $input.mapId}
			<a class="service-dialog-view floatleft" href="{service controller=object action=infobox type=trackeritem object=$input.mapId mode=divs}">{tr}Description{/tr}</a>
			{*trackeritemcheck itemId=$input.mapId mode='edit'}
				<a class="service-dialog-edit floatright" href="{service controller=tracker action=update_item itemId=$input.mapId trackerId=$input.trackerId}">{tr}Edit{/tr}</a>
			{/trackeritemcheck*}
		{elseif $input.sourceId}
			<a class="service-dialog-view floatleft" href="{service controller=object action=infobox type=trackeritem object=$input.sourceId mode=divs}">{tr}Description{/tr}</a>
		{/if}
		<a class="mymaps floatright" href="{tr}HomePage{/tr}">{tr}My Maps{/tr}</a>
	</p>
</div>
{jq}
	var page = {{$page|json_encode}};
	$('.map-info .service-dialog-view').click(function () {
		$(this).serviceDialog({
			title: $(this).text(),
			load: function () {
				$("h1:first a", this).parent().html($("h1:first a", this).text());	// remove a tag on title
				$("a.service-dialog:eq(1)", this).remove();							// and loose the confusing delete button
				$('.service-dialog').click(function () {
					$(this).serviceDialog({
						title: $(this).text(),
						success: function (data) {
							if (data.fields) {

								var url = page + "?mapId=@itemId@&coordinates=@mapBaseLocation@&shareCode=@shareCode@&mapName=@mapName@#Map"
									.replace("@itemId@", encodeURIComponent(data.itemId));

								$.each(data.fields, function () {
									url = url.replace("@" + this.permName + "@", encodeURIComponent(this.value));
								});
							} else {	// delete also returns via here but with only itemId and trackerId
								url = "./";
							}
							document.location.href = url;
						}
					})
					return false;
				});
			}
		});
		return false;
	});
	$('.map-info .service-dialog-edit').click(function () {
		$(this).serviceDialog({
			title: $(this).text(),
			success: function (data) {
				var url = page + "?mapId=@itemId@&coordinates=@mapBaseLocation@&shareCode=@shareCode@&mapName=@mapName@"
					.replace("@itemId@", encodeURIComponent(data.itemId));

				$.each(data.fields, function () {
					url = url.replace("@" + this.permName + "@", encodeURIComponent(this.value));
				});

				document.location.href = url;
			}
		});
		return false;
	});
	var id = {{if $input.mapId}{$input.mapId}{elseif $input.sourceId}{$input.sourceId}{/if}};
	if (!getCookie(id, "maps")) {
		setCookie(id, 1, "maps");
		setTimeout(function(){$('.map-info .service-dialog-view').click();}, 3000);
	}
{/jq}
