
<h3>{tr}Legend{/tr}</h3>
<form id="map-legend" method="get" action="tiki-searchindex.php">
	<input type="hidden" name="filter~tracker_id" value="{$input.trackerId|escape}"/>

	{if $input.shareCode}
		<input type="hidden" name="filter~tracker_field_map_shareCode" value="{$input.shareCode|escape}"/>
	{else}
		<input type="hidden" name="filter~tracker_field_map" value="{$input.mapId|escape}"/>
	{/if}
	<ul>
	</ul>
</form>
<form id="map-legend-add" method="post" action="{service controller=tracker action=insert_item trackerId=$input.trackerId}">
	<input type="hidden" name="trackerId" value="{$input.trackerId|escape}"/>
	<input type="hidden" name="forced~finder" value="{$user|escape}"/>
	<input type="hidden" name="forced~map" value="{$input.mapId|escape}"/>

	<input type="submit" value="{tr}New Entry{/tr}"/>
</form>
{jq}
	var mapId = {{$input.mapId|json_encode}};
	function refresh_legend() {
		var $form = $('#map-legend');
		$.getJSON($form.attr('action'), $form.serialize())
			.success(function (data) {
				var ul = $form.find('ul').empty();
				$.each(data, function (k, entry) {
					var item = $('<li/>')
						.text(entry.title)
						.prepend($('<img/>').attr('src', entry.tracker_field_legendIcon))
						.appendTo(ul);

					if (mapId == entry.tracker_field_map) {
						item.append($('<a class="editlink"/>')
							.text(tr('Edit'))
							.attr('href', $.service('tracker', 'update_item', {
								trackerId: entry.tracker_id,
								itemId: entry.object_id
							}))
							.click(function () {
								$(this).serviceDialog({
									success: refresh_legend
								});

								return false;
							}));
					}
				});
			});
	}

	refresh_legend();
	setInterval(refresh_legend, 2000*1000);

	$('#map-legend-add').submit(function () {
		$(this).serviceDialog({
			title: $(':submit', this).val(),
			controller: 'tracker',
			action: 'insert_item',
			data: $(this).serialize(),
			success: refresh_legend
		});
		return false;
	});
{/jq}
