{if $input.mapId}
	<form id="edit-share-code" method="post" action="{service controller=tracker action=update_item itemId=$input.mapId trackerId=$input.trackerId}">
		<label>
			{tr}Share Code{/tr}
			<input type="text" name="fields~shareCode" value="{$input.shareCode|escape}"/>
		</label>
		<input type="submit" value="{tr}Modify{/tr}"/>
	</form>
{/if}
{if $input.shareCode or ! $input.mapId}
<form method="POST" action="Map">
	<label>
		{tr}Public Permalink{/tr}
		<input id="permalink" type="url" value=""/>
	</label>
</form>
{/if}
{jq}
	var input = {{$input|json_encode}}
		, baseUrl = {{$base_url|json_encode}}
		;
	$('#edit-share-code').submit(function () {
		var form = this;

		$.post($(this).attr('action'), $(this).serialize(), function () {
			document.location.href = 
				'Map?coordinates=' + encodeURIComponent(input.coordinates)
				+ '&mapId=' + encodeURIComponent(input.mapId)
				+ '&mapName=' + encodeURIComponent(input.mapName)
				+ '&shareCode=' + encodeURIComponent($(':text', form).val())
				;
		}, 'json');
		return false;
	});
	$('#appframe .map-container').bind('initialized', function () {
		var container = this, updatePermalink;
		updatePermalink = function () {
			var url = baseUrl + 'Map?coordinates=' + encodeURIComponent($(container).getMapCenter());

			if (input.shareCode) {
				url = url
					+ '&shareCode=' + encodeURIComponent(input.shareCode)
					+ '&mapName=' + encodeURIComponent(input.mapName)
					;
			}

			$('#permalink')
				.val(url)
				.closest('form').attr('action', url);
		};

		this.map.events.on({
			move: updatePermalink
		});

		updatePermalink();
	});
	$('#permalink').focus(function () {
		$(this).select();
	});
{/jq}
