<a class="map-custom-print" href="">{tr}Print{/tr}</a>
{jq}
$('.map-custom-print').click(function (e) {
	e.preventDefault();
	var container = $('#appframe .map-container')[0];

	while (container.map.controls.length) {
		container.map.controls[0].deactivate();
		container.map.removeControl(container.map.controls[0]);
	}
	
	var elements = [];
	$(container).finalMapRefresh(function (result, feature) {
		elements.push({
			data: result,
			feature: feature
		});
	});

	var dialog = $('<div/>').dialog({
		modal: true,
		title: 'Loading...',
	});

	setTimeout(function () {
		var legend = $('#map-legend');

		$('#main')
			.empty()
			.append(container)
			.append(legend);

		var mapCount = elements.length + 1;

		$.each(elements, function (k, data) {
			var div = $('<div/>');

			div.css('clear', 'both');

			$('<div>').width(200).height(200)
				.css('float', 'left')
				.appendTo(div)
				.data('map-controls', '')
				.createMap()
				.bind('initialized', function () {
					this.vectors.addFeatures([data.feature]);
					this.map.zoomToExtent(data.feature.geometry.getBounds());

					if (container.map.getZoom() < this.map.getZoom()) {
						this.map.zoomTo(container.map.getZoom());
					}

					if (--mapCount === 0) {
						dialog.dialog('destroy');

						setTimeout(function () {
							window.print();
						}, 500);
					}
				});

			$('<h2>')
				.append(data.data.link)
				.appendTo(div);

			$('<div/>')
				.append(data.data.tracker_field_finder)
				.appendTo(div);

			var d = new Date(1000 * data.data.modification_date);
			$('<div/>')
				.append($.datepicker.formatDate('yy-mm-dd', d))
				.appendTo(div);

			$('<div/>')
				.append(data.data.tracker_field_zoneDescription)
				.append(data.data.tracker_field_poiDescription)
				.appendTo(div);

			$('#main').append(div);
		});

		if (--mapCount === 0) {
			dialog.dialog('destroy');

			setTimeout(function () {
				window.print();
			}, 500);
		}

	}, 5000);
	return false;
});
{/jq}
