{permission type=tracker object=$input.trackerId name='create_tracker_items'}
<form id="duplicate-form" class="simple center" method="post" action="{service controller=tracker action=clone_item}">
	<div class="submit">
		<input type="hidden" name="trackerId" value="{$input.trackerId|escape}"/>
		<input type="hidden" name="itemId" value="{$input.mapId|escape}"/>
		<input type="hidden" name="fields~shareCode" value=""/>
		<input type="hidden" name="fields~mapBaseLocation" value="{$input.coordinates|escape}"/>
		<input type="hidden" name="fields~mapName" value="{$input.mapName|cat:' '|cat:'{tr}copy{/tr}'|escape}"/>
		<input class="tips" title="{tr}Duplicate Map|Make your own copy of this map. Only the items you own will be copied.{/tr}" type="submit" value="{tr}Duplicate{/tr}"/>
	</div>
</form>

{jq}
	$('#duplicate-form').submit(function () {
		var newName = prompt(tr("Enter new map name"), $("input[name='fields~mapName']").val()),
				page = {{$page|json_encode}};
		if (newName) {
			$.modal("{tr}Duplicating...{/tr}");
			$("input[name='fields~mapName']").val(newName);
			$.post($(this).attr('action'), $(this).serialize(), function (data) {
				document.location.href = page + '?mapId=' + data.created + '&mapName=' + encodeURIComponent(data.data.mapName) + '&coordinates=' + encodeURIComponent(data.data.mapBaseLocation) + "#{tr}Map{/tr}";
			}, 'json');
		}
		return false;
	});
{/jq}
{/permission}
